* THIS DO-FILE IS FOR THE SECOND GENERATION IMMIGRANT ANALYSIS
* IT CREATES THE OUTPUT FOR TABLE 6 AND APPENDIX TABLES D3

clear all
use data\ESS_immigrants.dta

*_____________________
*	Table 6: Kin Networks in Mothers’ Originating Countries and Voting

preserve
keep if cntbrth_h==1 //keep only those that are born domestically
keep if mocntr==2 //only those where mother is from somewhere else
keep if citizen ==1 //only citizens
drop if ageb<18

*drop those where information where mother was born is missing
drop if mbrncnt =="99"
drop if mbrncnt =="88"
drop if mbrncnt =="77"
drop if mbrncnt =="06"
drop if mbrncnt =="04"
drop if mbrncnt =="03"
drop if mbrncnt =="02"

*drop observations with missing covariates ==> all specification have the same number of observations, which allows easy comparison
drop if education==. | rlgdnm==. | uempla==. | uempli==.
drop if dscrgrp==. | rlgdgr==. | ageb==. | ageb_sqrt==. | gndr==.    
drop if m_nu_rugged==. | m_ag_abslat==. | m_du_caloricsui==. | m_ag_distcr ==. | m_nu_european==.

local a m_nu_rugged m_ag_abslat m_du_caloricsui m_ag_distcr 
local y vote

* Panel 1: Cousin marriage preference
local v m_fs_cousin_pref_cont
eststo: xi: areg `y' `v'       ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry) 
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround                 dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround m_nu_european , absorb(cntry) cluster(cntry)
esttab using tables\Table6_Panel_1.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear

*Panel 2: Cousin-term differentiation
local v m_fs_diff_cousin 
eststo: xi: areg `y' `v'       ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry) 
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround                 dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround m_nu_european , absorb(cntry) cluster(cntry)
esttab using tables\Table6_Panel_2.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear

*Panel 3: Log % cousin marriage
local v m_bit_consang_ln
eststo: xi: areg `y' `v'       ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry) 
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround                 dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround m_nu_european , absorb(cntry) cluster(cntry)
esttab using tables\Table6_Panel_3.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear
restore








*_____________________
*	Table D3: Kin networks in Fathers’ Originating Countries and Political Activity
preserve
keep if cntbrth_h==1 //keep only those that are born domestically
keep if facntr==2 //only those where father is from somewhere else
*keep only those where we know where father is from
drop if fbrncnt =="99"
drop if fbrncnt =="88"
drop if fbrncnt =="77"
drop if fbrncnt =="06"
drop if fbrncnt =="04"
drop if fbrncnt =="03"
drop if fbrncnt =="02"

drop if education==. | rlgdnm==. | uempla==. | uempli==.
drop if dscrgrp==. | rlgdgr==. | ageb==. | ageb_sqrt==. | gndr==.    
drop if f_nu_rugged==. | f_ag_abslat==. | f_du_caloricsui==.  | f_ag_distcr ==. | f_nu_european==.

local a f_nu_rugged f_ag_abslat f_du_caloricsui f_ag_distcr 
local y active1_std

* Panel 1: Cousin marriage preference
local v f_fs_cousin_pref_cont
eststo: xi: areg `y' `v'       ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry) 
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround                 dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround f_nu_european , absorb(cntry) cluster(cntry)
esttab using tables\TableD3_Panel_1.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear

* Panel 2: Cousin-term differentiation
local v f_fs_diff_cousin 
eststo: xi: areg `y' `v'       ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry) 
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround                 dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround f_nu_european , absorb(cntry) cluster(cntry)
esttab using tables\TableD3_Panel_2.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear

* Panel 3: Log percent cousin marriage
local v f_bit_consang_ln
eststo: xi: areg `y' `v'       ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry) 
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround          , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround                 dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround i.rlgdnm rlgdgr dscrgrp i.education uempla uempli , absorb(cntry) cluster(cntry)
eststo: xi: areg `y' `v'   `a' ageb ageb_sqrt gndr i.essround f_nu_european , absorb(cntry) cluster(cntry)
esttab using tables\TableD3_Panel_3.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(3)) se(par fmt(3))) scalars(chi2 fs)
eststo clear

restore















